/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.service.managedsystem;

import com.ibm.hwmca.fw.service.managedsystem.FactoryResolutionException;
import com.ibm.hwmca.fw.service.managedsystem.ServiceableElement;
import com.ibm.hwmca.fw.service.managedsystem.ServiceableElementFilter;
import com.ibm.hwmca.fw.service.managedsystem.config.ManagedSystemConfigData;
import com.ibm.hwmca.fw.service.managedsystem.persist.ServiceableElementPersistence;
import com.ibm.hwmca.fw.service.managedsystem.persist.ServiceableElementPersistenceException;
import com.ibm.hwmca.fw.service.managedsystem.persist.ServiceableElementPersistenceFactory;
import com.ibm.hwmca.fw.util.Trace;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ManagedSystem {
    private static final String TRACE_MASKT = "XRVF03ET";
    private static final String TRACE_MASKF = "XRVF03EF";
    private static final String TRACE_MASKD = "XRVF03ED";
    private Map persistenceImplMap = new HashMap();
    private String machineType;
    private String machineModel;
    private ServiceableElementPersistenceFactory serviceableElementPersistenceFactory = null;
    private ManagedSystemConfigData configData;

    public ManagedSystem(ManagedSystemConfigData configData) {
        Trace.trace(TRACE_MASKT, "-> ManagedSystem ctor");
        this.configData = configData;
        this.machineType = configData.getType();
        this.machineModel = configData.getModel();
        Trace.trace(TRACE_MASKF, "ManagedSystem ctor for machine type[" + this.machineType + "],model[" + this.machineModel + "]");
        Trace.trace(TRACE_MASKT, "<- ManagedSystem ctor");
    }

    public Object getFactory(String factoryName) throws FactoryResolutionException {
        Trace.trace(TRACE_MASKT, "-> ManagedSystem.getFactory(" + factoryName + ")");
        try {
            Object factory = this.configData.getServiceInterfacesParser().getFactory(factoryName);
            Trace.trace(TRACE_MASKT, "<- ManagedSystem.getFactory(" + factoryName + "); returning " + factory);
            return factory;
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "<-! ManagedSystem.getFactory exception caught: " + e);
            Trace.trace(TRACE_MASKT, e);
            throw new FactoryResolutionException(e);
        }
    }

    public List filter(ServiceableElementFilter filter) throws ServiceableElementPersistenceException {
        Trace.trace(TRACE_MASKT, "-> ManagedSystem.filter(filter[" + filter + "])");
        List list = this.resolvePersistence(filter.getType()).load(filter);
        Trace.trace(TRACE_MASKT, "<- ManagedSystem.filter");
        return list;
    }

    public synchronized void add(ServiceableElement element) throws ServiceableElementPersistenceException {
        Trace.trace(TRACE_MASKT, "-> ManagedSystem.add(element[" + element + "])");
        this.resolvePersistence(element.getType()).store(element);
        Trace.trace(TRACE_MASKT, "<- ManagedSystem.add");
    }

    public synchronized void delete(ServiceableElement element) throws ServiceableElementPersistenceException {
        Trace.trace(TRACE_MASKT, "-> ManagedSystem.delete(element[" + element + "])");
        this.resolvePersistence(element.getType()).remove(element);
        Trace.trace(TRACE_MASKT, "<- ManagedSystem.delete");
    }

    public synchronized void update(ServiceableElement element) throws ServiceableElementPersistenceException {
        Trace.trace(TRACE_MASKT, "-> ManagedSystem.update(element[" + element + "])");
        this.resolvePersistence(element.getType()).store(element);
        Trace.trace(TRACE_MASKT, "<- ManagedSystem.update");
    }

    private ServiceableElementPersistence resolvePersistence(String type) throws ServiceableElementPersistenceException {
        if (!this.persistenceImplMap.containsKey(type)) {
            try {
                if (this.serviceableElementPersistenceFactory == null) {
                    this.serviceableElementPersistenceFactory = (ServiceableElementPersistenceFactory)this.getFactory("ServiceableElementPersistenceFactory");
                }
                ServiceableElementPersistence sep = this.serviceableElementPersistenceFactory.create(type);
                HashMap<String, String> initData = new HashMap<String, String>();
                initData.put("TYPE", this.machineType);
                initData.put("MODEL", this.machineModel);
                sep.init(initData);
                this.persistenceImplMap.put(type, sep);
            }
            catch (Exception e) {
                throw new ServiceableElementPersistenceException(e);
            }
        }
        return (ServiceableElementPersistence)this.persistenceImplMap.get(type);
    }
}

